#include <iostream>
#include <vector>
#include <algorithm>
#define int long long
using namespace std;

using namespace std;

struct point {
    int x, y;
    point() {
        x = y = 0;
    }
    point(int X, int Y) {
        x = X; y = Y;
    }

    point operator-(point a) {
        return { x - a.x, y - a.y };
    }

    long long operator*(point a) {
        return (long long)x * a.y - (long long)y * a.x;
    }
    bool operator==(point a) {
        return x == a.x && y == a.y;
    }
};

inline int sgn(long long x) {
    if (x == 0)
        return 0;
    if (x > 0)
        return 1;
    return -1;
}

inline bool check(vector<point> &v) {
    int n = (int)v.size();
    bool c = 0;
    for (int i = 0; i < n; ++i) {
        point p = v[i] - v[((i - 1) % n + n) % n];
        point p1 = v[(i + 1) % n] - v[i];
        point p2 = v[(i + 2) % n] - v[(i + 1) % n];
        if (sgn(p1 * p2) or sgn(p * p1))
            c = 1;
        if (sgn(p1 * p2) == 0 or sgn(p * p1) == 0 or sgn(p1 * p2) == sgn(p * p1))
            continue;
        return false;
    }
//    return true;
    if (c)
        return true;
    else {
        return (v[0] == v[1] or v[0] == v[3] or v[2] == v[1] or v[2] == v[3]);
    }
}

vector<vector<int>> gr;
vector<int> used;
int res;
void dfs(int v, int from) {
    used[v] = 1;
    for (auto &x : gr[v]) {
        if (x == from)
            continue;
        if (used[x] == 2)
            continue;
        if (used[x] == 1) {
            res++;
            continue;
        }
        dfs(x, v);
    }
    used[v] = 2;
}

void solve() {
    gr = {}; used = {};
    int n;
    cin >> n;
    gr.resize(n);
    vector<pair<point, point>> v(n);
    for (auto &p : v)
        cin >> p.first.x >> p.first.y >> p.second.x >> p.second.y;

    for (int i = 0; i < n; ++i) {
        vector<point> cur(4);
        cur[0] = v[i].first;
        cur[2] = v[i].second;
        for (int j = i + 1; j < n; ++j) {
            cur[1] = v[j].first;
            cur[3] = v[j].second;
            if (check(cur)) {
                gr[i].push_back(j);
                gr[j].push_back(i);
            }
        }
    }
    used.resize(n);
    res = 0;
    for (int i = 0; i < n; ++i) {
        if (!used[i])
            dfs(i, -1);
    }

    cout << res + 1 << '\n';
}
signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0); cout.tie(0);
    int t; cin >> t;
    while (t--)
        solve();
}

/*
2
4
1 1 2 2
2 2 3 3
1 3 3 3
1 3 1 1
4
1 1 2 2
3 3 4 4
1 3 3 3
1 3 1 1
 */